/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.domsec;

import com.ibm.hwmca.base.domsec.DomainSecurityIds;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.msgpanel.CommonMsgApp;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.IllegalUserDataException;
import com.ibm.ui.framework.TaskActionEvent;
import com.ibm.ui.framework.UserTaskManager;

public class DomainSecurityBean
extends PanelBean
implements DomainSecurityIds {
    private static final String TRACE_MASKT = "HACADSBT";
    private static final String TRACE_MASKF = "HACADSBF";
    private static final String TRACE_MASKD = "HACADSBD";
    private String m_sCurrentDomainNameOutput;
    private String m_sDomainNameEdit;
    private String m_sNewPasswordEdit;
    private String m_sVerifyPasswordEdit;
    private String[] m_sDomainSecurityChoiceSelection;

    public void update(Object result) {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.update(" + result + ")");
        if (this.getDomainNameEdit().length() > 0 && this.getDomainNameEdit().charAt(0) == '\u0000') {
            this.setCurrentDomainNameOutput("NOT SET");
        } else {
            this.setCurrentDomainNameOutput(this.getDomainNameEdit());
        }
        this.load();
        this.userTaskManager.refreshElement("CurrentDomainNameOutput");
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.update()");
    }

    public String getCurrentDomainNameOutput() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.getCurrentDomainNameOutput()");
        return this.m_sCurrentDomainNameOutput;
    }

    public void setCurrentDomainNameOutput(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.setCurrentDomainNameOutput()");
        this.m_sCurrentDomainNameOutput = s.toUpperCase();
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.setCurrentDomainNameOutput()");
    }

    public String getDomainNameEdit() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.getDomainNameEdit()");
        return this.m_sDomainNameEdit;
    }

    public void setDomainNameEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.setDomainNameEdit()");
        if (s.length() > 8) {
            this.m_sDomainNameEdit = s.substring(0, 8).toUpperCase();
            this.setCurrentDomainNameOutput(this.m_sDomainNameEdit);
        } else {
            this.m_sDomainNameEdit = s.toUpperCase();
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.setDomainNameEdit()");
    }

    public String getNewPasswordEdit() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.getNewPasswordEdit()");
        return this.m_sNewPasswordEdit;
    }

    public void setNewPasswordEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.setNewPasswordEdit()");
        this.m_sNewPasswordEdit = s.toUpperCase();
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.setNewPasswordEdit()");
    }

    public String getVerifyPasswordEdit() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.getVerifyPasswordEdit()");
        return this.m_sVerifyPasswordEdit;
    }

    public void setVerifyPasswordEdit(String s) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.setVerifyPasswordEdit()");
        this.m_sVerifyPasswordEdit = s.toUpperCase();
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.setVerifyPasswordEdit()");
    }

    public String[] getDomainSecurityChoiceSelection() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.getDomainSecurityChoiceSelection()");
        return this.m_sDomainSecurityChoiceSelection;
    }

    public void setDomainSecurityChoiceSelection(String[] selected) throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.setDomainSecurityChoiceSelection()");
        this.m_sDomainSecurityChoiceSelection = selected;
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.setDomainSecurityChoiceSelection()");
    }

    public Capabilities getCapabilities() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.getCapabilities()");
        return null;
    }

    public void prepare() {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.prepare()");
        this.userTaskManager.setShown("ResetMfgDefaultItem", true);
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.prepare()");
    }

    public void verifyChanges() throws IllegalUserDataException {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.verifyChanges()");
    }

    public void save() {
        Trace.trace(TRACE_MASKT, "<> DomainSecurityBean.save()");
    }

    public void load() {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.load()");
        this.m_sDomainNameEdit = "";
        this.m_sNewPasswordEdit = "";
        this.m_sVerifyPasswordEdit = "";
        this.m_sDomainSecurityChoiceSelection = new String[]{"ApplyHMCItem"};
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.load()");
    }

    public void panelAction(TaskActionEvent evt) {
        Trace.trace(TRACE_MASKT, "-> DomainSecurityBean.panelAction(" + evt + ")");
        String cmd = evt.getActionCommand();
        Trace.trace(TRACE_MASKD, "DomainSecurityBean.panelAction(): Command is = " + cmd);
        if (cmd.equals("CANCEL")) {
            Trace.trace(TRACE_MASKD, "DomainSecurityBean.panelAction(): Handler: Cancel button.");
            PanelTaskletRequest request = new PanelTaskletRequest();
            request.setData("event", cmd);
            this.postTaskletRequest(request);
        } else {
            UserTaskManager utm = (UserTaskManager)evt.getSource();
            if (utm == null) {
                Trace.trace(TRACE_MASKD, "DomainSecurityBean.panelAction(): evt.getSource returned null for UserTaskManager.");
            } else {
                utm.storeAllElements();
                DomainSecurityBean bean = (DomainSecurityBean)utm.getDataObjects()[0];
                if (cmd.equals("OkButton")) {
                    if (this.getDomainSecurityChoiceSelection().length != 0 && this.getDomainSecurityChoiceSelection()[0] != null) {
                        if (this.getDomainSecurityChoiceSelection()[0].equals("ResetMfgDefaultItem")) {
                            if (this.getDomainNameEdit().length() == 0 && this.getNewPasswordEdit().length() == 0) {
                                PanelTaskletRequest request = new PanelTaskletRequest();
                                request.setData("event", "ResetMfgDefaultItem");
                                this.postTaskletRequest(request);
                            } else {
                                this.displayMessage("HACA800F", "HACA000F");
                            }
                        } else if (this.getDomainNameEdit() != null && this.getDomainNameEdit().length() > 0 || this.getNewPasswordEdit() != null && this.getNewPasswordEdit().length() > 0) {
                            if (this.isDomainValid() && this.isPasswordValid()) {
                                PanelTaskletRequest request = new PanelTaskletRequest();
                                if (this.getDomainSecurityChoiceSelection()[0].equals("ApplyHMCItem")) {
                                    request.setData("event", "ApplyHMCItem");
                                } else {
                                    request.setData("event", "ApplyDefinedObjectsItem");
                                }
                                request.setData("data", bean);
                                this.postTaskletRequest(request);
                            }
                        } else {
                            this.displayMessage("HACA800C", "HACA000C");
                        }
                    } else {
                        this.displayMessage("HACA800E", "HACA000E");
                    }
                } else {
                    Trace.trace(TRACE_MASKD, "DomainSecurityBean.panelAction(): Selection not supported.");
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- DomainSecurityBean.panelAction()");
    }

    private boolean isDomainValid() {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityBean.isDomainValid()");
        boolean isValid = true;
        if (this.getDomainNameEdit() != null && this.getDomainNameEdit().length() > 0) {
            int i = 0;
            while (i < this.getDomainNameEdit().length() && isValid) {
                if (!(this.getDomainNameEdit().charAt(i) >= 'A' && this.getDomainNameEdit().charAt(i) <= 'Z' || this.getDomainNameEdit().charAt(i) >= '0' && this.getDomainNameEdit().charAt(i) <= '9')) {
                    isValid = false;
                    this.displayMessage("HACA800G", "HACA000G");
                }
                ++i;
            }
        }
        Trace.trace(TRACE_MASKF, "<- DomainSecurityBean.isDomainValid(): returns " + isValid);
        return isValid;
    }

    private boolean isPasswordValid() {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityBean.isPasswordValid()");
        boolean isValid = true;
        boolean oneNumeric = false;
        if (this.getNewPasswordEdit() != null && this.getNewPasswordEdit().length() > 0) {
            if (!this.getNewPasswordEdit().equals(this.getVerifyPasswordEdit())) {
                isValid = false;
                this.displayMessage("HACA8004", "HACA0004");
            } else if (this.getNewPasswordEdit().length() < 6 || this.getNewPasswordEdit().length() > 8 || this.getVerifyPasswordEdit().length() < 6 || this.getVerifyPasswordEdit().length() > 8) {
                isValid = false;
                this.displayMessage("HACA8003", "HACA0003");
            } else if (this.getNewPasswordEdit().charAt(0) >= '0' && this.getNewPasswordEdit().charAt(0) <= '9' || this.getNewPasswordEdit().charAt(this.getNewPasswordEdit().length() - 1) >= '0' && this.getNewPasswordEdit().charAt(this.getNewPasswordEdit().length() - 1) <= '9') {
                isValid = false;
                this.displayMessage("HACA8007", "HACA0007");
            } else {
                int i = 0;
                while (i < this.getNewPasswordEdit().length() && isValid) {
                    if (!(this.getNewPasswordEdit().charAt(i) >= 'A' && this.getNewPasswordEdit().charAt(i) <= 'Z' || this.getNewPasswordEdit().charAt(i) >= '0' && this.getNewPasswordEdit().charAt(i) <= '9')) {
                        isValid = false;
                        this.displayMessage("HACA8005", "HACA0005");
                    } else if (i < this.getNewPasswordEdit().length() - 2 && this.getNewPasswordEdit().charAt(i) == this.getNewPasswordEdit().charAt(i + 1) && this.getNewPasswordEdit().charAt(i + 1) == this.getNewPasswordEdit().charAt(i + 2)) {
                        isValid = false;
                        this.displayMessage("HACA8006", "HACA0006");
                    } else if (this.getNewPasswordEdit().charAt(i) >= '0' && this.getNewPasswordEdit().charAt(i) <= '9') {
                        oneNumeric = true;
                    }
                    ++i;
                }
                if (isValid && !oneNumeric) {
                    isValid = false;
                    this.displayMessage("HACA8007", "HACA0007");
                }
            }
        }
        Trace.trace(TRACE_MASKF, "<- DomainSecurityBean.isPasswordValid(): returns " + isValid);
        return isValid;
    }

    private void displayMessage(String t, String m) {
        Trace.trace(TRACE_MASKF, "-> DomainSecurityBean.displayMessage(" + t + ", " + m + ")");
        try {
            BaseMessageTitle title = new BaseMessageTitle(t);
            BaseMessageText message = new BaseMessageText(m);
            CommonMsgApp.showMessageBox(this.userTaskManager, title, message);
        }
        catch (Exception exc) {
            Trace.trace(TRACE_MASKF, exc);
        }
        Trace.trace(TRACE_MASKF, "<- DomainSecurityBean.displayMessage()");
    }
}

